/*
 * Decompiled with CFR 0.152.
 */
package rrkm;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import rrkm.RRKM_Control;
import rrkm.Tabs_TabbedPane;

public class Tab_Tabular_Output_Panel
extends JPanel {
    private static final long serialVersionUID = -2463010904557133557L;
    private JTable table_output = new JTable();
    private DefaultTableModel tm = (DefaultTableModel)this.table_output.getModel();
    private Clipboard system;
    private StringSelection content;

    public Tab_Tabular_Output_Panel(RRKM_Control control) {
        GridBagLayout gbl_panel_tab_output = new GridBagLayout();
        gbl_panel_tab_output.columnWeights = new double[]{0.0, 0.0};
        gbl_panel_tab_output.rowWeights = new double[]{0.0, 0.0, 0.0};
        this.setLayout(gbl_panel_tab_output);
        this.table_output.setCellSelectionEnabled(false);
        this.table_output.setColumnSelectionAllowed(false);
        this.table_output.setModel(new DefaultTableModel(new Object[0][], new String[]{"Energy", "Density of States (reac)", "Density of States (trans)", "Sum of States (trans)", "k(E)"}){
            private static final long serialVersionUID = -6282319667397023239L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table_output);
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(15, 15, 15, 15);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.gridheight = 2;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        this.add((Component)scrollPane, gbc_scrollPane);
        JButton button_copyToClipboard = new JButton("Copy to Clipboard");
        button_copyToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Tab_Tabular_Output_Panel.this.setSystemClipboard();
            }
        });
        GridBagConstraints gbc_button_copyToClipboard = new GridBagConstraints();
        gbc_button_copyToClipboard.insets = new Insets(0, 0, 15, 15);
        gbc_button_copyToClipboard.fill = 2;
        gbc_button_copyToClipboard.anchor = 15;
        gbc_button_copyToClipboard.weighty = 1.0;
        gbc_button_copyToClipboard.gridx = 1;
        gbc_button_copyToClipboard.gridy = 0;
        this.add((Component)button_copyToClipboard, gbc_button_copyToClipboard);
        JButton button_saveAs = new JButton("Save As...");
        button_saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser filechooser = new JFileChooser();
                filechooser.setSelectedFile(new File(String.valueOf(((Tabs_TabbedPane)Tab_Tabular_Output_Panel.this.getParent()).getMolName()) + "_outputData.csv"));
                filechooser.showSaveDialog(Tab_Tabular_Output_Panel.this.getParent());
                if (filechooser.getSelectedFile() != null) {
                    try {
                        FileWriter writer = new FileWriter(filechooser.getSelectedFile());
                        String content = Tab_Tabular_Output_Panel.this.setOutputFileContent();
                        writer.write(content);
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        GridBagConstraints gbc_button_saveAs = new GridBagConstraints();
        gbc_button_saveAs.insets = new Insets(0, 0, 15, 15);
        gbc_button_saveAs.fill = 1;
        gbc_button_saveAs.gridx = 1;
        gbc_button_saveAs.gridy = 1;
        this.add((Component)button_saveAs, gbc_button_saveAs);
    }

    public void setResultVector(Vector<Vector<Double>> resultVector, double energyStart, double energyStep, double energyThreshold) {
        this.cleanOutputTable();
        int step = (int)energyStep;
        int shift = (int)energyThreshold;
        int i = 0;
        while (i < resultVector.get(0).size()) {
            if (!(resultVector.get(0).get(i) < energyStart)) {
                Vector<Double> rowData = new Vector<Double>();
                rowData.add(resultVector.get(0).get(i));
                rowData.add(resultVector.get(1).get(i));
                try {
                    rowData.add(resultVector.get(2).get(i - shift));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    rowData.add(0.0);
                }
                try {
                    rowData.add(resultVector.get(3).get(i - shift));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    rowData.add(0.0);
                }
                rowData.add(resultVector.get(4).get(i));
                this.addResultLine(rowData);
            }
            i += step;
        }
    }

    private void addResultLine(Vector<Double> rowData) {
        this.tm = this.getOutputTableModel();
        this.tm.addRow(rowData);
    }

    private DefaultTableModel getOutputTableModel() {
        return (DefaultTableModel)this.table_output.getModel();
    }

    private void cleanOutputTable() {
        this.tm = this.getOutputTableModel();
        this.tm.setRowCount(0);
    }

    private void setSystemClipboard() {
        this.tm = this.getOutputTableModel();
        int rowCount = this.tm.getRowCount();
        int colCount = this.tm.getColumnCount();
        StringBuffer buffer = new StringBuffer();
        if (rowCount == 0) {
            return;
        }
        int i = 0;
        while (i < rowCount) {
            int j = 0;
            while (j < colCount) {
                buffer.append(this.table_output.getValueAt(i, j) + "\t");
                if (j == colCount - 1) {
                    buffer.append("\n");
                }
                ++j;
            }
            ++i;
        }
        this.content = new StringSelection(buffer.toString());
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.system.setContents(this.content, this.content);
    }

    private String setOutputFileContent() {
        this.tm = this.getOutputTableModel();
        int rowCount = this.tm.getRowCount();
        int colCount = this.tm.getColumnCount();
        StringBuffer buffer = new StringBuffer();
        if (rowCount == 0) {
            return null;
        }
        int i = 0;
        while (i < rowCount) {
            int j = 0;
            while (j < colCount) {
                buffer.append(this.table_output.getValueAt(i, j) + ";");
                if (j == colCount - 1) {
                    buffer.append(System.getProperty("line.separator"));
                }
                ++j;
            }
            ++i;
        }
        return buffer.toString();
    }
}

