/*
 * Decompiled with CFR 0.152.
 */
package rrkm;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;

public class RRKM_TableKeyListener
implements KeyListener {
    private DefaultTableModel tm;
    private JTable table;
    private int colCount;
    private int rowCount;

    public RRKM_TableKeyListener(JTable table) {
        this.table = table;
        this.tm = (DefaultTableModel)table.getModel();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.colCount = this.tm.getColumnCount();
        this.rowCount = this.tm.getRowCount();
        if (e.getKeyCode() == KeyStroke.getKeyStroke("ENTER").getKeyCode()) {
            this.addLine();
            this.changeFocus();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void addLine() {
        boolean lastEmpty = true;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (this.rowCount > 1) {
            int i = 0;
            while (i < this.colCount) {
                if (this.tm.getValueAt(this.rowCount - 1, i) != null) {
                    lastEmpty = false;
                }
                ++i;
            }
            if (!lastEmpty) {
                this.tm.addRow(new String[this.colCount]);
            }
        } else {
            this.tm.addRow(new String[this.colCount]);
        }
    }

    private void changeFocus() {
        if (this.colCount > 1 && this.table.getSelectedColumn() == this.colCount - 1 && this.table.getSelectedRow() == this.rowCount - 1) {
            int tmp = this.rowCount - 1;
            if (this.table.getValueAt(tmp, this.colCount - 1) != null && this.table.getValueAt(tmp, 0) == null) {
                this.table.changeSelection(tmp - 1, 0, false, false);
            } else {
                this.table.changeSelection(tmp, 0, false, false);
            }
        }
    }
}

