/*
 * Decompiled with CFR 0.152.
 */
package rrkm;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import javax.swing.JPanel;
import rrkm.Tab_Graphical_Output_Panel;

public class GraphPanel
extends JPanel {
    private static final long serialVersionUID = 7067794205991591764L;
    private Vector<Vector<Double>> resultVector;
    private double parentWidth;
    private double parentHeight;
    private double plotWidth;
    private double plotHeight;
    private double padding;
    private double labelspace;
    private double yDownline;
    private double[] energy;
    private double[] dosr;
    private double[] dost;
    private double[] sost;
    private double[] rate;
    private int plotSteps;
    private int[] xPoints;
    private int[] yPoints;
    private double xpart;
    private double ypart_dosr;
    private double yLogpart_dosr;
    private double ypart_dost;
    private double yLogpart_dost;
    private double ypart_sost;
    private double yLogpart_sost;
    private double ypart_rate;
    private double yLogpart_rate;
    private int selectValue;
    private boolean logAxis;

    public void setResultVector(Vector<Vector<Double>> resultVector, double energyStart, double energyStep, double energyThreshold) {
        int step;
        this.resultVector = resultVector;
        int shift = (int)energyThreshold;
        this.plotSteps = (int)((resultVector.get(0).lastElement() - energyStart) / energyStep);
        if (this.plotSteps < 200) {
            step = (int)(0.005 * (resultVector.get(0).lastElement() - energyStart));
            this.plotSteps = (int)((resultVector.get(0).lastElement() - energyStart) / (double)step);
        } else {
            step = (int)energyStep;
        }
        this.energy = new double[this.plotSteps];
        this.dosr = new double[this.plotSteps];
        this.dost = new double[this.plotSteps];
        this.sost = new double[this.plotSteps];
        this.rate = new double[this.plotSteps];
        int i = 0;
        int j = 0;
        while (j < this.plotSteps) {
            if (resultVector.get(0).get(i) < energyStart) {
                --j;
            } else if (resultVector.get(4).get(i) < 1.0) {
                --j;
                --this.plotSteps;
            } else {
                this.energy[j] = resultVector.get(0).get(i);
                this.dosr[j] = resultVector.get(1).get(i);
                try {
                    this.dost[j] = resultVector.get(2).get(i - shift);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.dost[j] = 1.0;
                }
                try {
                    this.sost[j] = resultVector.get(3).get(i - shift);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.sost[j] = 1.0;
                }
                this.rate[j] = resultVector.get(4).get(i);
            }
            i += step;
            ++j;
        }
    }

    private void initSize() {
        this.parentWidth = this.getWidth();
        this.parentHeight = this.getHeight();
        this.padding = this.parentWidth > this.parentHeight ? 0.02 * this.parentWidth : 0.02 * this.parentHeight;
        double d = this.labelspace = this.parentWidth > this.parentHeight ? 0.05 * this.parentWidth : 0.05 * this.parentHeight;
        if (this.labelspace > 60.0) {
            this.labelspace = 50.0;
        }
        this.plotWidth = this.parentWidth - (this.labelspace + this.padding + this.padding);
        this.plotHeight = this.parentHeight - (this.labelspace + this.padding + this.padding);
        this.yDownline = this.padding + this.plotHeight;
    }

    private void initPlotRange() {
        this.xpart = this.plotWidth / (this.energy[this.plotSteps - 1] - this.energy[0]);
        this.ypart_dosr = this.plotHeight / (this.dosr[this.plotSteps - 1] - this.dosr[0]);
        this.yLogpart_dosr = this.plotHeight / (Math.log10(this.dosr[this.plotSteps - 1]) - Math.log10(this.dosr[0]));
        this.ypart_dost = this.plotHeight / (this.dost[this.plotSteps - 1] - this.dost[0]);
        this.yLogpart_dost = this.plotHeight / (Math.log10(this.dost[this.plotSteps - 1]) - Math.log10(this.dost[0]));
        this.ypart_sost = this.plotHeight / (this.sost[this.plotSteps - 1] - this.sost[0]);
        this.yLogpart_sost = this.plotHeight / (Math.log10(this.sost[this.plotSteps - 1]) - Math.log10(this.sost[0]));
        this.ypart_rate = this.plotHeight / (this.rate[this.plotSteps - 1] - this.rate[0]);
        this.yLogpart_rate = this.plotHeight / (Math.log10(this.rate[this.plotSteps - 1]) - Math.log10(this.rate[0]));
    }

    private void drawAxis(Graphics g) {
        double xStart = this.labelspace + this.padding;
        double xEnd = this.labelspace + this.padding + this.plotWidth;
        double yStart = this.padding + this.plotHeight;
        g.drawLine((int)xStart, (int)this.yDownline, (int)xEnd, (int)this.yDownline);
        g.drawLine((int)(xEnd - 5.0), (int)(this.yDownline - 5.0), (int)xEnd, (int)this.yDownline);
        g.drawLine((int)(xEnd - 5.0), (int)(this.yDownline + 5.0), (int)xEnd, (int)this.yDownline);
        g.drawLine((int)xStart, (int)yStart, (int)xStart, (int)this.padding);
        g.drawLine((int)(xStart - 5.0), (int)(this.padding + 5.0), (int)xStart, (int)this.padding);
        g.drawLine((int)(xStart + 5.0), (int)(this.padding + 5.0), (int)xStart, (int)this.padding);
        char c = '\u207b';
        char d = '\u00b9';
        String xlabel = "energy [cm" + c + d + "]";
        g.drawString(xlabel, (int)(0.5 * this.parentWidth - 15.0), (int)(this.yDownline + this.labelspace));
        this.drawXTicks(g);
        if (this.logAxis) {
            switch (this.selectValue) {
                case 1: {
                    String yLogLabel_dosr = "Log. Density of states (reactant) [cm]";
                    this.ylabel(g, (int)(this.padding - 5.0), (int)(this.padding + 0.5 * this.plotHeight + 65.0), yLogLabel_dosr);
                    this.drawYLogTicks(g, this.dosr, this.yLogpart_dosr);
                    break;
                }
                case 2: {
                    String yLogLabel_dost = "Log. Density of states (transition state) [cm]";
                    this.ylabel(g, (int)(this.padding - 5.0), (int)(this.padding + 0.5 * this.plotHeight + 95.0), yLogLabel_dost);
                    break;
                }
                case 3: {
                    String yLogLabel_sost = "Log. Sum of states (transition state) [1]";
                    this.ylabel(g, (int)(this.padding - 5.0), (int)(this.padding + 0.5 * this.plotHeight + 90.0), yLogLabel_sost);
                    this.drawYLogTicks(g, this.sost, this.yLogpart_sost);
                    break;
                }
                default: {
                    String yLogLabel_rate = "Log. reaction rate [s " + c + d + "]";
                    this.ylabel(g, (int)(this.padding - 5.0), (int)(this.padding + 0.5 * this.plotHeight + 35.0), yLogLabel_rate);
                    this.drawYLogTicks(g, this.rate, this.yLogpart_rate);
                    break;
                }
            }
        } else {
            switch (this.selectValue) {
                case 1: {
                    String yLabel_dosr = "Density of states (reactant) [cm]";
                    this.ylabel(g, (int)(this.padding - 5.0), (int)(this.padding + 0.5 * this.plotHeight + 65.0), yLabel_dosr);
                    this.drawYTicks(g, this.dosr, this.ypart_dosr);
                    break;
                }
                case 2: {
                    String yLabel_dost = "Density of states (transition state) [cm]";
                    this.ylabel(g, (int)(this.padding - 5.0), (int)(this.padding + 0.5 * this.plotHeight + 95.0), yLabel_dost);
                    this.drawYTicks(g, this.dost, this.ypart_dost);
                    break;
                }
                case 3: {
                    String yLabel_sost = "Sum of states (transition state) [1]";
                    this.ylabel(g, (int)(this.padding - 5.0), (int)(this.padding + 0.5 * this.plotHeight + 90.0), yLabel_sost);
                    this.drawYTicks(g, this.sost, this.ypart_sost);
                    break;
                }
                default: {
                    String yLabel_rate = "reaction rate [s " + c + d + "]";
                    this.ylabel(g, (int)(this.padding - 5.0), (int)(this.padding + 0.5 * this.plotHeight + 35.0), yLabel_rate);
                    this.drawYTicks(g, this.rate, this.ypart_rate);
                }
            }
        }
    }

    private void drawXTicks(Graphics g) {
        int y1 = (int)this.yDownline;
        int y2 = (int)(this.yDownline + 0.5 * this.padding);
        int i = 0;
        while ((double)i < this.energy[this.plotSteps - 1] - 500.0) {
            if (!((double)i < this.energy[0])) {
                int xKoor = (int)(this.padding + this.labelspace + ((double)i - this.energy[0]) * this.xpart);
                g.setColor(Color.BLACK);
                g.drawLine(xKoor, y1, xKoor, y2);
                g.drawString("" + i, xKoor - 16, (int)((double)y2 + this.padding));
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(xKoor, (int)this.yDownline, xKoor, (int)this.padding);
            }
            i += 5000;
        }
    }

    private void drawYTicks(Graphics g, double[] values, double ypart) {
        int x1 = (int)this.labelspace;
        int x2 = (int)(this.labelspace + this.padding);
        double yrange = values[this.plotSteps - 1] - values[0];
        double adding = 0.01;
        int j = 0;
        double i = yrange;
        while (i > 1.0) {
            adding *= 10.0;
            ++j;
            i /= 10.0;
        }
        i = 0.0;
        while (i < values[this.plotSteps - 1]) {
            if (!(i < values[0])) {
                int yKoor = (int)(this.yDownline - (i - values[0]) * ypart);
                g.setColor(Color.BLACK);
                g.drawLine(x1, yKoor, x2, yKoor);
                g.drawString(String.valueOf(0.1 * i / adding) + "E" + (j - 1), (int)this.padding + 2, yKoor - 4);
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(x2, yKoor, (int)((double)x2 + this.plotWidth), yKoor);
            }
            i += 5.0 * adding;
        }
    }

    private void drawYLogTicks(Graphics g, double[] values, double ypart) {
        int x1 = (int)this.labelspace;
        int x2 = (int)(this.labelspace + this.padding);
        double i = 1.0;
        double j = 0.0;
        while (i < values[this.plotSteps - 1]) {
            if (!(i < values[0])) {
                int yKoor = (int)(this.yDownline - (Math.log10(i) - Math.log10(values[0])) * ypart);
                g.setColor(Color.BLACK);
                g.drawLine(x1, yKoor, x2, yKoor);
                g.drawString("1.0E" + (int)j, (int)this.padding + 2, yKoor - 4);
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(x2, yKoor, (int)((double)x2 + this.plotWidth), yKoor);
            }
            i *= 10.0;
            j += 1.0;
        }
        if (values[this.plotSteps - 1] / values[0] < 20.0) {
            this.drawYMinorLogTicks(g, values, ypart);
        }
    }

    private void drawYMinorLogTicks(Graphics g, double[] values, double ypart) {
        double i = 1.0;
        while (i < values[this.plotSteps - 1]) {
            if (!(i < values[0])) {
                int x1 = (int)(this.labelspace + 0.5 * this.padding);
                int x2 = (int)(this.labelspace + this.padding);
                double j = 1.0;
                double k = 0.1;
                while (j < 10.0) {
                    int yKoorDown = (int)(this.yDownline - (Math.log10(k * i) - Math.log10(values[0])) * ypart);
                    int yKoorUp = (int)(this.yDownline - (Math.log10(j * i) - Math.log10(values[0])) * ypart);
                    if (k * i > values[0]) {
                        g.setColor(Color.BLACK);
                        g.drawLine(x1, yKoorDown, x2, yKoorDown);
                        g.setColor(Color.LIGHT_GRAY);
                        g.drawLine(x2, yKoorDown, (int)((double)x2 + this.plotWidth), yKoorDown);
                    }
                    if (j * i < values[this.plotSteps - 1]) {
                        g.setColor(Color.BLACK);
                        g.drawLine(x1, yKoorUp, x2, yKoorUp);
                        g.setColor(Color.LIGHT_GRAY);
                        g.drawLine(x2, yKoorUp, (int)((double)x2 + this.plotWidth), yKoorUp);
                    }
                    j += 1.0;
                    k += 0.1;
                }
            }
            i *= 10.0;
        }
    }

    private void createPlotData(double[] xvalues, double[] yvalues, double ypart) {
        this.xPoints = new int[this.plotSteps];
        this.yPoints = new int[this.plotSteps];
        int i = 0;
        while (i < this.plotSteps) {
            this.xPoints[i] = (int)(this.padding + this.labelspace + (xvalues[i] - xvalues[0]) * this.xpart);
            this.yPoints[i] = (int)(this.yDownline - (yvalues[i] - yvalues[0]) * ypart);
            ++i;
        }
    }

    private void createLogPlotData(double[] xvalues, double[] yvalues, double ypart) {
        this.xPoints = new int[this.plotSteps];
        this.yPoints = new int[this.plotSteps];
        int i = 0;
        while (i < this.plotSteps) {
            this.xPoints[i] = (int)(this.padding + this.labelspace + (xvalues[i] - xvalues[0]) * this.xpart);
            this.yPoints[i] = (int)(this.yDownline - (Math.log10(yvalues[i]) - Math.log10(yvalues[0])) * ypart);
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.selectValue = ((Tab_Graphical_Output_Panel)this.getParent()).getSelectValue();
        this.logAxis = ((Tab_Graphical_Output_Panel)this.getParent()).getLogAxis();
        this.initSize();
        if (this.resultVector == null) {
            g.setColor(this.getParent().getBackground());
            g.fillRect(0, 0, (int)this.parentWidth, (int)this.parentHeight);
        } else {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, (int)this.parentWidth, (int)this.parentHeight);
            this.initPlotRange();
            g.setColor(Color.BLACK);
            this.drawAxis(g);
            if (this.logAxis) {
                switch (this.selectValue) {
                    case 1: {
                        this.createLogPlotData(this.energy, this.dosr, this.yLogpart_dosr);
                        break;
                    }
                    case 2: {
                        this.createLogPlotData(this.energy, this.dost, this.yLogpart_dost);
                        break;
                    }
                    case 3: {
                        this.createLogPlotData(this.energy, this.sost, this.yLogpart_sost);
                        break;
                    }
                    case 4: {
                        this.createLogPlotData(this.energy, this.rate, this.yLogpart_rate);
                        break;
                    }
                }
                g.setColor(Color.BLACK);
                Graphics2D g2D = (Graphics2D)g;
                g2D.setStroke(new BasicStroke(3.0f));
                if (this.selectValue == 2) {
                    g2D.drawString("log(0) prevents a meaningful drawing! Uncheck the 'log. axis' checkbox", 100, 100);
                } else {
                    g2D.drawPolyline(this.xPoints, this.yPoints, this.plotSteps);
                }
            } else {
                switch (this.selectValue) {
                    case 1: {
                        this.createPlotData(this.energy, this.dosr, this.ypart_dosr);
                        break;
                    }
                    case 2: {
                        this.createPlotData(this.energy, this.dost, this.ypart_dost);
                        break;
                    }
                    case 3: {
                        this.createPlotData(this.energy, this.sost, this.ypart_sost);
                        break;
                    }
                    case 4: {
                        this.createPlotData(this.energy, this.rate, this.ypart_rate);
                        break;
                    }
                }
                g.setColor(Color.BLACK);
                Graphics2D g2D = (Graphics2D)g;
                g2D.setStroke(new BasicStroke(3.0f));
                g2D.drawPolyline(this.xPoints, this.yPoints, this.plotSteps);
            }
        }
    }

    private void ylabel(Graphics g, int x, int y, String label) {
        Graphics2D g2D = (Graphics2D)g;
        AffineTransform fontAT = new AffineTransform();
        Font curFont = g2D.getFont();
        fontAT.rotate(4.71238898038469);
        g2D.setFont(curFont.deriveFont(fontAT));
        g2D.setColor(Color.BLACK);
        g2D.drawString(label, x, y);
        g2D.setFont(curFont);
    }
}

